/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

//	NewDrawing.cpp

#include <stdafx.h>

#include "CUtility.h"
#include "CFile.h"
#include "CApplication.h"

// Create New Drawing and return the newly created Drawing.
HRESULT NewDrawing(IDrawingDocument **retval) 
{
	START_METHOD("NewDrawing")

	HRESULT status = CONV_SUCCESS;

	IApplication *pdApplication = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	IDrawingDocument *pDisp = NULL;
	status = pdApplication->NewDrawing(&pDisp);
	CHECK_RETURN_STATUS(status)

	*retval = pDisp;

	END_METHOD("NewDrawing")
}
